package unipotsdam.informatikkiste;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Bundle;
import android.app.Activity;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.MediaController;
import android.widget.VideoView;

public class VideoActivity extends Activity implements View.OnClickListener {

    public static boolean reset;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        //Remove title bar
        this.requestWindowFeature(Window.FEATURE_NO_TITLE);

        //Remove notification bar
        this.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        setContentView(R.layout.activity_main);

        setContentView(R.layout.activity_video);

        ((Button)findViewById(R.id.button_next)).setOnClickListener(this);

        final VideoView videoView = (VideoView)findViewById(R.id.videoView);
        final MediaController mediaController = new MyMediaController(this);
        mediaController.setMediaPlayer(videoView);
        videoView.setMediaController(mediaController);
        Uri uri = Uri.parse("android.resource://" + getPackageName() + "/" + R.raw.opening_vid_lr_lq);
        videoView.setVideoURI(uri);
        videoView.setZOrderOnTop(true);
        videoView.start();
        videoView.setZOrderOnTop(true);

        AudioManager audioManager = (AudioManager)getSystemService(Context.AUDIO_SERVICE);
        audioManager.setStreamVolume(AudioManager.STREAM_MUSIC, audioManager.getStreamMaxVolume(AudioManager.STREAM_MUSIC), 0);

        VideoActivity.reset = false;

        final Handler handler = new Handler();
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                mediaController.show(4000);
            }
        }, 1000);
    }

    @Override
    public void onResume(){
        super.onResume();

        if(VideoActivity.reset){
            super.onBackPressed();
        }
        else{
            ((VideoView)findViewById(R.id.videoView)).start();
        }
    }

    @Override
    public void onClick(View v) {
        if(v.getId() == R.id.button_next){
            Intent intent = new Intent(this, MainActivity.class);
            this.startActivity(intent);
        }
    }

    public static class SquareVideoView extends VideoView{

        public SquareVideoView(Context context) {
            super(context);
        }

        public SquareVideoView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public SquareVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
        }

        public void onMeasure(int widthMeasureSpec, int heightMeasureSpec){
            int size = Math.min(MeasureSpec.getSize(widthMeasureSpec),MeasureSpec.getSize(heightMeasureSpec));
            int width = MeasureSpec.makeMeasureSpec(size,MeasureSpec.EXACTLY);
            int height = MeasureSpec.makeMeasureSpec(size,MeasureSpec.EXACTLY);
            setMeasuredDimension(width,height);
        }
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }

    public class MyMediaController extends MediaController{

        public MyMediaController(Context context){
            super(context);
        }

        @Override
        public void show(){
            show(0);
        }
    }
}
